﻿<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Deklaracje.PPK" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ import Namespace="System.Linq" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Karta przychodow pracownika</title>
		<script runat="server">
	
    class Total {
    
           public class Item {
               readonly PrnParams pars;
               readonly SrParams srpars;
               readonly int rok;
               readonly int miesiąc;
               decimal brutto;
               decimal korekta;
               decimal koszty;
               decimal dochód;
               decimal narastająco;
               decimal nalFis;
               decimal zdrowotne;
               decimal zdrowotneDoOdliczenia;
               decimal zanFis;
               decimal zalFis;
               decimal pod8ar;
               Percent procentFis;
               bool failed;
               decimal emerytalne;
               decimal rentowe;
               decimal chorobowe;
               decimal ppkf;
               decimal emerytalneOdliczone;
               decimal rentoweOdliczone;
               decimal choroboweOdliczone;
               decimal przychod50;
               decimal koszty50;
               decimal koszty50um;
               decimal kosztyZusPomn;
               decimal ulgaKlasaSrednia;
               Pracownik pracownik;
               public Item() {
               }
               public Item(Pracownik pracownik, int rok, int miesiąc, PrnParams pars, SrParams srpars) {
                   this.pars = pars;
                   this.srpars = srpars;
                   this.rok = rok;
                   this.miesiąc = miesiąc;
                   this.pracownik = pracownik;
               }
               public void Add(Item item) {
                   brutto += item.brutto;
                   korekta += item.korekta;
                   koszty += item.koszty;
                   dochód += item.dochód;
                   narastająco += item.narastająco;
                   nalFis += item.nalFis;
                   zdrowotne += item.zdrowotne;
                   zdrowotneDoOdliczenia += item.zdrowotneDoOdliczenia;
                   ulgaKlasaSrednia +=  item.ulgaKlasaSrednia;
                   zalFis += item.zalFis;
                   pod8ar += item.pod8ar;
                   zanFis += item.zanFis;
                   emerytalne += item.emerytalne;
                   rentowe += item.rentowe;
                   chorobowe += item.chorobowe;
                   ppkf += item.ppkf;
                   emerytalneOdliczone += item.emerytalneOdliczone;
                   rentoweOdliczone += item.rentoweOdliczone;
                   choroboweOdliczone += item.choroboweOdliczone;
                   przychod50 += item.przychod50;
                   koszty50 += item.koszty50;
                   koszty50um += item.koszty50um;
                   kosztyZusPomn += item.kosztyZusPomn;

					if (!failed)
						if (item.failed)
							failed = true;						
						else if (procentFis==Percent.Zero)
							procentFis = item.procentFis;
						else if (item.procentFis!=Percent.Zero && item.procentFis!=procentFis)
							failed = true;
               }
               public void Add(Soneta.Place.Wyplata w) {
					if (!failed) {
						Soneta.Place.Wyplata.PITInfoWorker worker = new Soneta.Place.Wyplata.PITInfoWorker();
						worker.Wypłata = w;
						Percent pw = worker.ProcentPit;
						if (procentFis==Percent.Zero)
							procentFis = pw;
						else if (pw!=Percent.Zero && pw!=procentFis)
							failed = true;
					}
               }
               public void AddPPK(Pracownik pracownik, YearMonth okres) {
                    this.ppkf = SkładkaPPK(pracownik, okres);
               }
               static bool ZgodnyZUS(WypElement e, FromTo okres) {
                    Debug.Assert(okres == FromTo.Empty || okres.Contains(e.Data));
                    return e.MiesiacDeklaracji == e.MiesiacZUS || okres != FromTo.Empty && new YearMonth(okres.From) <= e.MiesiacZUS && e.MiesiacZUS <= new YearMonth(okres.To);
               }
               public void Add(WypElement e, FromTo okres) {
                   decimal b = e.DoOpodatkowania;
                   decimal k = e.Podatki.KosztyPIT;
                   decimal sz = e.Podatki.PomnKosztyZUS;

                   if (!ZgodnyZUS(e, okres)) {
                       if (e.MiesiacDeklaracji != e.MiesiacZUS)
                           korekta += sz;
                       else {
                           emerytalne += e.Podatki.Emerytalna.Prac;
                           rentowe += e.Podatki.Rentowa.Prac;
                           chorobowe += e.Podatki.Chorobowa.Prac;
                           if (e.Podatki.PomniejszeniePodstawyFIS) {
                               emerytalneOdliczone += e.Podatki.Emerytalna.Prac;
                               rentoweOdliczone += e.Podatki.Rentowa.Prac;
                               choroboweOdliczone += e.Podatki.Chorobowa.Prac;
                               kosztyZusPomn += e.Podatki.PomnKosztyZUS;
                           }
                       }
                       dochód -= sz;
                       narastająco -= sz;
                       sz = 0;
                   }
                   else {
                       emerytalne += e.Podatki.Emerytalna.Prac;
                       rentowe += e.Podatki.Rentowa.Prac;
                       chorobowe += e.Podatki.Chorobowa.Prac;
                       if (e.Podatki.PomniejszeniePodstawyFIS) {
                           emerytalneOdliczone += e.Podatki.Emerytalna.Prac;
                           rentoweOdliczone += e.Podatki.Rentowa.Prac;
                           choroboweOdliczone += e.Podatki.Chorobowa.Prac;
                           kosztyZusPomn += e.Podatki.PomnKosztyZUS;
                       }
                   }
                       
                   if (e.Definicja.Info.Opodatkowany) {
                       brutto += b;
					   dochód += b - e.Podatki.Przychod26;
					   narastająco += b;
                   }
                   dochód -= e.Podatki.UlgaKlasaSrednia;
				   dochód -= k;
				   narastająco -= k;
                   if (srpars.DochódZUS && e.Definicja.Deklaracje.Zaliczka.PomniejszonaZUS != TypPomniejszeniaPodstawyFIS.False) {
                       dochód -= sz;
                       narastająco -= sz;
				   }
                   koszty += k;
                   nalFis += e.Podatki.NalFIS;
                   zdrowotne += e.Podatki.Zdrowotna.Prac;
                   ulgaKlasaSrednia += e.Podatki.UlgaKlasaSrednia;
                   zdrowotneDoOdliczenia += e.Podatki.ZdrowotneDoOdliczenia;
                   zanFis += e.Podatki.Przychod26;
                   if (!e.Podatek) {
                        przychod50 += e.Podatki.Przychod50;
                        koszty50 += e.Podatki.Koszty50;
                        if (e.Wyplata is WyplataUmowa) {
                            decimal koszt50 = 0;
                            switch (e.Definicja.Deklaracje.Koszty.Typ) {
                                case TypKosztowUzyskaniaPrzychodu.Procentowe:
                                case TypKosztowUzyskaniaPrzychodu.Procentowe50:
                                case TypKosztowUzyskaniaPrzychodu.ProcentoweWarunkowo:
                                    if (e.Definicja.Deklaracje.Koszty.Procent == new Percent(0.5M)) {
                                        if (e.Podatki.Koszty > 0)
                                            koszt50 = e.Podatki.Koszty;
                                        else
                                            koszt50 = e.Podatki.Koszty50;
                                    }
                                    else
                                        koszt50 = e.Podatki.Koszty50;
                                    break;
                                default:
                                    koszt50 = e.Podatki.Koszty50;
                                    break;
                            }
                            koszty50um += koszt50;
                        }
                   }
				   if (!pars.Podatek)
						zalFis += e.Podatki.ZalFIS;
				   else {
						if (e.Podatek)
							pod8ar += e.Podatki.ZalFIS;
						else
							zalFis += e.Podatki.ZalFIS;
				   }
                   decimal skl = SkładkaPPK(e.Pracownik, e, new YearMonth(rok, miesiąc));
                   if (ppkf == 0)
                       ppkf = skl;
               }
               private decimal SkładkaPPK(Pracownik pracownik, WypElement e, YearMonth ym) {
                    if (e.Definicja.Guid == new Guid("00000000-0007-0002-0214-000000000000") ||
                        e.Definicja.Guid == new Guid("00000000-0007-0002-0215-000000000000"))
                        return e.Wartosc;
                    return SkładkaPPK(pracownik, ym);
               }
               private decimal SkładkaPPK(Pracownik pracownik, YearMonth ym) {
                    decimal skladka = 0;
                    decimal etat, etat26, umowa, umowa26, pozostałe, spółdzielnie;            
                    SkładkiPPK.NierozliczonyPrzychód(pracownik, ym, out etat, out etat26, out umowa, out umowa26, out spółdzielnie, out pozostałe);
                    if ((pars.Przychody & Przychody.Pracownika)!=0 || (pars.Przychody & Przychody.Wieloetatowość)!=0)
                        skladka += etat;
                    if ((pars.Przychody & Przychody.Zleceniobiorcy)!=0)
                        skladka += umowa;
                    return skladka;
               }

                 public int Rok
                {
                    get { return rok; }
                }

               public int Miesiąc {
                   get { return miesiąc; }
               }
               public decimal Brutto {
                   get {
                        if (korekta < 0)
                            return brutto - korekta;
                        return brutto;
                   }
               }
               public decimal Koszty {
                   get { return koszty; }
               }
               public decimal Dochód {
                   get { return dochód; }
               }
               public decimal Narastająco {
                   get { return narastająco; }
                   set { narastająco = value; }
               }
               public decimal NalFIS {
                   get { return nalFis; }
               }
               public decimal Zdrowotne {
                   get { return zdrowotne; }
               }
               public decimal ZdrowotneDoOdliczenia {
                   get { return zdrowotneDoOdliczenia; }
               }
               public decimal UlgaKlasaSrednia {
                   get { return ulgaKlasaSrednia; }
               }
               public decimal ZanFIS {
                   get { return zanFis; }
               }
               public decimal ZalFIS {
                   get { return zalFis; }
               }
               public decimal Przychod50 {
                   get { return przychod50; }
               }
               public decimal Koszty50 {
                   get { return koszty50; }
               }
               public decimal Koszty50um {
                   get { return koszty50um; }
               }
               public decimal Pod8AR {
                   get { return pod8ar; }
               }
               public Percent ProcentFIS {
				   get { return failed ? Percent.Zero : procentFis; }
               }
               public Date DataZaliczki {
                   get {
                       //if(ZalFIS == null || ZalFIS == 0)
                       //  return Date.Empty; 

                       DeklaracjeModule deklaracje = DeklaracjeModule.GetInstance(pracownik);
                       PIT4 pit4 = null;
                       FromTo okres = new YearMonth(rok, miesiąc).ToFromTo();
                       Soneta.Business.View v = deklaracje.Deklaracje[TypDeklaracji.PIT4, okres].CreateView();
                       if (pracownik.Wydzial != null) {
                           Wydzial w = pracownik.Wydzial.WydziałPIT;
                           if (w != null)
                               v.Condition &= new FieldCondition.Equal("ElementStrukturyFirmy", w);                               
                       }
                       foreach (PIT4 p in v)
                           if (pit4==null || pit4.Numer.Numer<p.Numer.Numer)
                               pit4 = p;
    
                       if (pit4==null)
                           return Date.Empty;
    
                       Date d = Date.Empty;
                       foreach (Platnosc p in pit4.Platnosci) {
                           Date dr = Date.Empty;
                           foreach (RozliczenieSP r in p.Rozliczenia)
                               if (dr<r.Data)
                                   dr = r.Data;
                           if (dr==Date.Empty)
                               dr = p.Termin;
                           if (d<dr)
                               d = dr;
                       }
    
                       return d;
                   }
               }
               public decimal Emerytalne {
                   get { return emerytalne; }
               }
               public decimal Rentowe {
                   get { return rentowe; }
               }
               public decimal Chorobowe {
                   get { return chorobowe; }
               }
               public decimal PPKF {
                   get { return ppkf; }
               }
               public decimal Społeczne {
					get {
                        decimal zus = emerytalne + rentowe + chorobowe;
                        if (korekta < 0)
                            return zus;
                        return zus + korekta;                            
                    }
               }
               public decimal EmerytalneOdliczone {
                   get { return emerytalneOdliczone; }
               }
               public decimal RentoweOdliczone {
                   get { return rentoweOdliczone; }
               }
               public decimal ChoroboweOdliczone {
                   get { return choroboweOdliczone; }
               }
               public decimal SpołeczneOdliczone {
                   get { return kosztyZusPomn; }
               }
           }

           readonly PrnParams pars;
           readonly SrParams srpars;
           readonly Pracownik pracownik;
           readonly Przychody przychody;
           readonly PracHistoria historia;
           readonly Item[] result = new Item[12];
           readonly List<Pracownik> powiązani = new List<Pracownik>();
           private bool wchodzi = false;
           public Total(Pracownik pracownik, FromTo okres, Przychody przychody, PrnParams pars, SrParams srpars) {
               this.pars = pars;
               this.srpars = srpars;
               this.przychody = przychody;
               int r = okres.To.Year;
               for (int i=0; i<12; i++)
                   result[i] = new Item(pracownik, r, i+1, pars, srpars);
    
               this.pracownik = pracownik;
               this.historia = pracownik[okres.To];
            
               if ((przychody & Przychody.Wieloetatowość) != 0)
                   foreach (Pracownik pp in pracownik.PracownicyPowiązani) {
                       if (!powiązani.Contains(pp) && pp != pracownik)
                           powiązani.Add(pp);
                       Policz(pp, okres);
                   }
               else
                   Policz(pracownik, okres);

               for (int i=1; i<12; i++)
                   result[i].Narastająco += result[i-1].Narastająco;
           }
           private void Policz(Pracownik pp, FromTo okres) {
               PlaceModule pl = PlaceModule.GetInstance(pp);
               SubTable st = pl.Wyplaty.WgPracownik[pp];
               st = new SubTable(st, okres);
    
               foreach (Soneta.Place.Wyplata w in st) {
                   try {
				       if (Filter(w) && !WypłataPoZgonie(w)) {
                           int m = w.Data.Month;
                           result[m-1].Add(w);
                           foreach (WypElement e in w.Elementy) {
                               result[m-1].Add(e, okres);
                               wchodzi = true;
                           }
                       }
                   }
                   catch { Msg(false); }
               }

               var ps = Soneta.Types.Periods.New(okres).BreakByMonth();
               foreach (FromTo o in ps) {
                    int m = o.From.Month;
                    if(result[m - 1].PPKF == 0)
                        result[m - 1].AddPPK(Pracownik, o.ToYearMonth());
               }
           }
           bool Filter(Soneta.Place.Wyplata w) {
				switch(przychody) {
					case Przychody.PracownikaZleceniobiorcy:
                    case Przychody.Razem:
						return true;
                    case Przychody.Wieloetatowość:
						return (w.Typ!=TypWyplaty.Umowa);
					default:
						return (w.Typ==TypWyplaty.Umowa)==(przychody==Przychody.Zleceniobiorcy);
				}
           }           
           public Pracownik Pracownik {
               get { return pracownik; }
           }
           public PracHistoria Historia {
               get { return historia; }
           }
           public string Powiązani {
               get {
                    string ss = "";
                    foreach (Pracownik p in powiązani)
                        ss += (ss != "" ? ", " : "") + p;
                    return ss;
               }               
           }    
           public Przychody Przychody {
               get { return przychody; }
           }
           public bool Wchodzi {
               get { return wchodzi; }
           }
           public IEnumerable<Item> Elementy {
               get { return result; }
           }
           public IEnumerable Sumy {
			   get { 
			       Item suma = new Item();
				   foreach (Item item in result)
				       suma.Add(item);
				   return new object[] { suma }; 
			   }
           }
           public bool JestP26 {
			   get {
                   decimal p26 = 0;
				   foreach (Item item in result)
				       p26 += item.ZanFIS;
				   return p26 != 0; 
			   }
           }
       };
    
		[Flags]
		public enum Przychody {
			Pracownika					= 0x01, 
			Zleceniobiorcy				= 0x02, 
			[Caption("Pracownika/Zleceniobiorcy")]
			PracownikaZleceniobiorcy	= Pracownika|Zleceniobiorcy,
            Wieloetatowość              = 0x04,
			Razem						= 0x07,
		}
		
		public class PrnParams: ContextBase {
	    
			public PrnParams(Context context): base(context) {
				Date data = ((ActualDate)context[typeof(ActualDate)]).Actual;
				okres = FromTo.Year(data.Year);
			}

			FromTo okres;
			[Required]
			[Priority(1)]
			public FromTo Okres {
				get { return okres; }
				set {
					okres = value;
					OnChanged(EventArgs.Empty);
				}
			}

			bool szczegółowa = false;
			[Priority(2)]
			public bool Szczegółowa {
				get { return szczegółowa; }
				set {
					szczegółowa = value;
					OnChanged(EventArgs.Empty);
				}
			}

			Przychody przychody = Przychody.Pracownika;
			[Priority(3)]
			public Przychody Przychody {
				get { return przychody; }
				set { 
					przychody = value; 
					OnChanged(EventArgs.Empty);
				}
			}
            
			bool podatek = false;
			[Priority(4)]
            [Caption("Osobno pod. PIT-8AR")]
            public bool Podatek {
                get { return podatek; }
				set {
                    podatek = value;
					OnChanged(EventArgs.Empty);
				}
			}

            bool info50;
            [Priority(5)]
            [Caption("Informacje o 50% KUP")]
            public bool Info50 {
                get { return info50; }
                set {
                    info50 = value;
                    OnChanged(EventArgs.Empty);
                }
            }
		}

        public class SrParams : SerializableContextBase {
            public SrParams(Context context) : base(context) {
            }

            //Wartość kolumn dochód oraz dochód narastająco pomniejszaj o składki ZUS
            //static bool dochódZUS = true;
            bool dochódZUS = true;
            [Priority(1)]
            [Caption("Dochód minus skł. ZUS")]
            public bool DochódZUS {
                get { return dochódZUS; }
                set {
                    dochódZUS = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }
		
		PrnParams pars;
		[Context(Required=true)]
		public PrnParams Params {
			get { return pars; }
			set { pars = value; }
		}

        SrParams srpars;
        [SettingsContext]
        public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }		

        private bool JestPPK(ISessionable session, FromTo okres) {
            YearMonth podlegaOd = PlaceModule.GetInstance(session).Config.PracowniczePlanyKapitałowe.Ogólne.PodlegaOd;
            return podlegaOd != YearMonth.Empty ? new FromTo(podlegaOd.FirstDay, Date.MaxValue).IsIntersected(okres) : false;
        }

		string nazwaOkresu;
    
		void OnContextLoad(Object sender, EventArgs args) {
            report = ReportHeader1;
			if (pars.Okres == FromTo.Year(pars.Okres.From.Year))
				nazwaOkresu = pars.Okres.From.Year + " rok";
			else
				nazwaOkresu = "okres " + pars.Okres.ToString();

			Row[] rows = (Row[])dc[typeof(Row[])];
			ArrayList result = new ArrayList();
            List<Pracownik> list = new List<Pracownik>();
            foreach (Pracownik idx in rows) {
                if ((pars.Przychody & Przychody.Wieloetatowość) != 0) {
                    if (!list.Contains(idx.EtatGłówny)) {
                        Przelicz(result, idx.EtatGłówny, pars.Przychody);
                        list.Add(idx.EtatGłówny);
                    }
                }
                else {
                    Przelicz(result, idx, Przychody.Pracownika);
                    Przelicz(result, idx, Przychody.Zleceniobiorcy);
                }
            }

            if (!pars.Podatek) {
                colPod8AR.Visible = false;
                colPod8ARR.Visible = false;
            }

            p50.Visible = k50.Visible = k50um.Visible = pars.Info50;
            p50t.Visible = k50t.Visible = k50umt.Visible = pars.Info50;

            if (!JestPPK(dc.Context.Session, pars.Okres)) {
                colPPKF.Visible = false;
                colPPKF2.Visible = false;
            }

			DataRepeater1.DataSource = result;
		}
		
		void Przelicz(ArrayList lista, Pracownik pracownik, Przychody przychody) {
			if ((pars.Przychody&przychody)!=0) {
				Total t = new Total(pracownik, pars.Okres, przychody, pars, srpars);
				if (t.Wchodzi)
					lista.Add(t);
			}
		}
    
		void OnBeforeRow(Object sender, EventArgs args) {
           Total t = (Total)DataRepeater1.CurrentRow;
           
			string info;
			if (t.Przychody!=Przychody.PracownikaZleceniobiorcy)
				info = " " + t.Przychody.ToString().ToLower();
			else
				info = "";
           
           string idpod;
           if (t.Historia.IdentyfikatorPodatkowy == IdentyfikatorPodatkowyPracownika.NIP)
               idpod = string.Format("NIP:<strong> {0}", t.Historia.NIP);
           else
               idpod = string.Format("PESEL:<strong> {0}", t.Historia.PESEL);
           string powiązani = t.Powiązani;

           string msg = Msg(true);
           if (string.IsNullOrEmpty(powiązani))
               ReportHeader1.Title = string.Format("Karta przychodów{6} za {0}<br>(ewidencja wynagrodzeń{6})|{1}|</strong>Urodzony:<strong> {2}, {3}|</strong>{4}|</strong>Adres:<strong> {5}|{7}",
                   nazwaOkresu,
                   t.Pracownik,
                   t.Historia.Urodzony.Data, t.Historia.Urodzony.Miejsce,
                   idpod,
                   t.Historia.Adres,
                   info,
                   msg);
           else
               ReportHeader1.Title = string.Format("Karta przychodów{6} za {0}<br>(ewidencja wynagrodzeń{6})|Etat główny: {1}|Etaty dodatkowe: {7}|</strong>Urodzony:<strong> {2}, {3}|</strong>{4}|</strong>Adres:<strong> {5}|{8}",
                   nazwaOkresu,
                   t.Pracownik,
                   t.Historia.Urodzony.Data, t.Historia.Urodzony.Miejsce,
                   idpod,
                   t.Historia.Adres,
                   info,
                   powiązani,
                   msg);

            colP26_1.Visible = colP26_2.Visible = t.JestP26;

            if(!t.Elementy.Any(x=> x.Rok < 2022)){
                ZdrowotnaRazem1.Visible = DoOdliczeniaZdrowotna2.Visible = DoOdliczeniaZdrowotna.Visible = false;
                 colUlgaKlasaSSum.Visible = colUlgaKlasaSrednia.Visible = ZdrowotnaRazem2.Visible = true;
            }
            else{
               colUlgaKlasaSSum.Visible = colUlgaKlasaSrednia.Visible = ZdrowotnaRazem2.Visible = false;
               ZdrowotnaRazem1.Visible = true;
               }
        }
    
		void Grid1_BeforeRow(Object sender, RowEventArgs args) {
			Total.Item item = (Total.Item)args.Row;
			if (!pars.Szczegółowa) {
				colSpoleczne.EditValue = item.Społeczne;
				colSpoleczneOdliczone.EditValue = item.SpołeczneOdliczone;
			}
			else {
				decimal d = item.Emerytalne + item.Rentowe + item.Chorobowe;
				if (d>0) {
					colSpoleczne.AddLine("{0:n} E", item.Emerytalne);
					colSpoleczne.AddLine("{0:n} R", item.Rentowe);
					colSpoleczne.AddLine("{0:n} C", item.Chorobowe);
		    
					//colSpoleczneOdliczone.AddLine("{0:n} E", item.EmerytalneOdliczone);
					//colSpoleczneOdliczone.AddLine("{0:n} R", item.RentoweOdliczone);
					//colSpoleczneOdliczone.AddLine("{0:n} C", item.ChoroboweOdliczone);
				    colSpoleczneOdliczone.EditValue = item.SpołeczneOdliczone;
				}
			}

            if (JestPPK(pars.Session, pars.Okres))
                colPPKF.EditValue = item.PPKF == 0 ? "" : item.PPKF.ToString("n");

		}

		void Grid2_BeforeRow(Object sender, RowEventArgs args) {
			Total.Item item = (Total.Item)args.Row;
			if (!pars.Szczegółowa) {
				colSpoleczne2.EditValue = item.Społeczne;
				colSpoleczneOdliczone2.EditValue = item.SpołeczneOdliczone;
			}
			else {
				colSpoleczne2.AddLine("{0:n} E", item.Emerytalne);
				colSpoleczne2.AddLine("{0:n} R", item.Rentowe);
				colSpoleczne2.AddLine("{0:n} C", item.Chorobowe);        
				colSpoleczne2.AddLine("<strong>{0:n}&nbsp;&nbsp;&nbsp;</strong>", item.Emerytalne + item.Rentowe + item.Chorobowe);

				//colSpoleczneOdliczone2.AddLine("{0:n} E", item.EmerytalneOdliczone);
				//colSpoleczneOdliczone2.AddLine("{0:n} R", item.RentoweOdliczone);
				//colSpoleczneOdliczone2.AddLine("{0:n} C", item.ChoroboweOdliczone);
				//colSpoleczneOdliczone2.AddLine("<strong>{0:n}&nbsp;&nbsp;&nbsp;</strong>", item.EmerytalneOdliczone + item.RentoweOdliczone + item.ChoroboweOdliczone);
				colSpoleczneOdliczone2.EditValue = item.SpołeczneOdliczone;
			}

            if (JestPPK(pars.Session, pars.Okres))
                colPPKF2.EditValue = item.PPKF == 0 ? "" : item.PPKF.ToString("n");
		}
    
		public static bool WypłataPoZgonie(Soneta.Place.Wyplata wypłata) {
			WyplataUmowa wu = wypłata as WyplataUmowa;
			Ubezpieczenia ubezpieczenia = null;
			if (wu!=null) {
				Umowa umowa = wu.Umowa;
				if (umowa!=null)
                    ubezpieczenia = umowa[wypłata.Data].Ubezpieczenia;
			}
			else
				ubezpieczenia = wypłata.Pracownik[wypłata.ListaPlac.Okres.To].Etat.Ubezpieczenia;
			
			return ubezpieczenia!=null && ubezpieczenia.Zdrowotne.ZgonPracownika(wypłata.Data);
		}
    
		public static void Msg(object obj) {
		}

        public static ReportHeader report;

        public static string Msg(bool flag) {
            string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
            if (report != null && !report.Title.Contains(msg))
                if (flag)
                    msg = "";
                else
                    report.Title += "|" + msg;
            return msg;
        }

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="KartaPrzychodowPracownika" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" Landscape="True" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:datarepeater id="DataRepeater1" runat="server" Height="140px" Width="100%" onbeforerow="OnBeforeRow">
				<P>
					<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
                    <font face="Tahoma">
					<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" ID="ReportHeader1" runat="server" 
                        title="Karta przychodów pracownika"></cc1:ReportHeader></font>
					<ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" 
                    DataMember="Elementy">
						<Columns>
							<ea:GridColumn Align="Center" DataMember="Miesiąc" NoWrap="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Brutto" Format="{0:n}" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Koszty" Format="{0:n}" 
                                Caption="Koszty uzyskania razem" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" ID="p50" DataMember="Przychod50" Format="{0:n}"
                                Caption="Przychód<br/>50% KUP etat" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" ID="k50" DataMember="Koszty50" Format="{0:n}"
                                Caption="50% KUP etat" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" ID="k50um" DataMember="Koszty50um" Format="{0:n}"
                                Caption="Koszty 50% um.cywil." HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" Format="{0:n}" ID="colSpoleczne" 
                                Caption="Składki na ubezpieczenia społeczne~Razem" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" Format="{0:n}" ID="colSpoleczneOdliczone" 
                                Caption="Składki na ubezpieczenia społeczne~W tym pomniejsz. podst. opodat." 
                                HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" Format="{0:n}" ID="colPPKF" 
                                Caption="Składki PPK~pracod." 
                                HideZero="True"></ea:GridColumn>
                            <ea:GridColumn ID="colUlgaKlasaSrednia" Align="Right" Format="{0:n}"
                                Caption="Ulga klasy średniej" 
                                DataMember="UlgaKlasaSrednia" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Doch&#243;d" Format="{0:n}" 
                                Caption="Podstawa obliczenia zaliczki" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" Caption="Dochód narastająco" 
                                DataMember="Narastająco" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="NalFIS" Format="{0:n}" 
                                Caption="Obliczona zaliczka na podatek" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" Caption="Procent zaliczki podatku" 
                                DataMember="ProcentFIS" HideZero="True"></ea:GridColumn>
							<ea:GridColumn ID="ZdrowotnaRazem1" Align="Right" DataMember="Zdrowotne" Format="{0:n}" 
                                Caption="Składka na ubezpieczenie zdrowotne~Razem" HideZero="True"></ea:GridColumn>
                            <ea:GridColumn ID="ZdrowotnaRazem2" Align="Right" DataMember="Zdrowotne" Format="{0:n}" 
                                Caption="Składka na ubezpieczenie zdrowotne" HideZero="True"></ea:GridColumn>
							<ea:GridColumn ID="DoOdliczeniaZdrowotna" Align="Right"  DataMember="ZdrowotneDoOdliczenia" Format="{0:n}" 
                                Caption="Składka na ubezpieczenie zdrowotne~W tym do odliczenia" 
                                HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="ZanFIS" Format="{0:n}" ID="colP26_1"
                                Caption="Przychód zw. art. 21 u.1 p. 148" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="ZalFIS" Format="{0:n}" 
                                Caption="Należna zaliczka podatku" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Pod8AR" Format="{0:n}" ID="colPod8AR"
                                Caption="Podatek PIT 8AR" HideZero="True"></ea:GridColumn>
							<ea:GridColumn Align="Center" Caption="Data przekazania zaliczki do US" 
                                DataMember="DataZaliczki"></ea:GridColumn>
						</Columns>
					</ea:Grid>
					<ea:Grid ID="Grid2" runat="server" DataMember="Sumy" 
                    OnBeforeRow="Grid2_BeforeRow" ShowHeader="None">
						<Columns>
							<ea:GridColumn Align="Right" Format="&lt;strong&gt;Razem:&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Brutto" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Koszty" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Przychod50" ID="p50t"
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Koszty50" ID="k50t"
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Koszty50um" ID="k50umt"
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn ID="colSpoleczne2" Align="Right" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn ID="colSpoleczneOdliczone2" Align="Right" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn ID="colPPKF2" Align="Right" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
                            <ea:GridColumn ID="colUlgaKlasaSSum" Align="Right" 
                                DataMember="UlgaKlasaSrednia"  Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Dochód" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="NalFIS" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Zdrowotne" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn ID="DoOdliczeniaZdrowotna2" Align="Right" DataMember="ZdrowotneDoOdliczenia" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="ZanFIS" ID="colP26_2" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="ZalFIS" 
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn Align="Right" DataMember="Pod8AR" ID="colPod8ARR"
                                Format="&lt;strong&gt;{0:n}&lt;/strong&gt;"></ea:GridColumn>
							<ea:GridColumn></ea:GridColumn>
						</Columns>                
					</ea:Grid>
					<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
			</P>
			</ea:datarepeater>
		</form>
	</body>
</HTML>
